	function [Zc, Pc] = PZ_CANCEL(Z, P, Tol)
	
	%	Removes any canceling poles and zeros that have a 
	%	difference in magnitude that is less than Tol.
  
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Oscar Gustafsson, 2009-07-15
	% 	Modified by: 	LW 2009-07-21
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	if nargin < 3
		Tol = 1e-6;
	end
	pc = [];
	zc = [];
	for k = 1:length(P)
		for l = 1:length(Z)
			if(abs(P(k)-Z(l)) <= Tol)
				pc = [pc k];
				zc = [zc l];
			end
		end
	end
	Pc = P;
	Pc(pc) = [];
	Zc = Z;
	Zc(zc) = [];
